<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" encoding="UTF-8" indent="yes"/>

	<!-- Global variables {{{ -->
	<!-- if exists, then the report is for export to word and excel -->
	<xsl:param name="EXPORTED_REPORT"/>

	<!-- Report variables -->
	<xsl:variable name="processId" select="/report/@processId"/>

	<!-- Page variables -->
	
	<!-- Header row -->
	<xsl:variable name="headerFontName">
		<xsl:choose>
			<xsl:when test="//headerFontName"><xsl:value-of select="//headerFontName"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Arial'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="headerFontSize">
		<xsl:choose>
			<xsl:when test="//headerFontSize"><xsl:value-of select="//headerFontSize"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'12'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="headerForeColor">
		<xsl:choose>
			<xsl:when test="//headerForeColor"><xsl:value-of select="//headerForeColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Black'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="headerBackColor">
		<xsl:choose>
			<xsl:when test="//headerBackColor"><xsl:value-of select="//headerBackColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'#ADAA9C'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="headerBold" select="//headerBold/text() = 'true'"/>
	<xsl:variable name="headerItalic" select="//headerItalic/text() = 'true'"/>
	
	<!-- Even row -->
	<xsl:variable name="evenFontName">
		<xsl:choose>
			<xsl:when test="//evenFontName"><xsl:value-of select="//evenFontName"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Arial'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="evenFontSize">
		<xsl:choose>
			<xsl:when test="//evenFontSize"><xsl:value-of select="//evenFontSize"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'12'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="evenForeColor">
		<xsl:choose>
			<xsl:when test="//evenForeColor"><xsl:value-of select="//evenForeColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Black'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="evenBackColor">
		<xsl:choose>
			<xsl:when test="//evenBackColor"><xsl:value-of select="//evenBackColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'White'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="evenBold" select="//evenBold/text() = 'true'"/>
	<xsl:variable name="evenItalic" select="//evenItalic/text() = 'true'"/>

	<!-- Odd row -->
	<xsl:variable name="oddFontName">
		<xsl:choose>
			<xsl:when test="//oddFontName"><xsl:value-of select="//oddFontName"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Arial'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="oddFontSize">
		<xsl:choose>
			<xsl:when test="//oddFontSize"><xsl:value-of select="//oddFontSize"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'12'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="oddForeColor">
		<xsl:choose>
			<xsl:when test="//oddForeColor"><xsl:value-of select="//oddForeColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Black'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="oddBackColor">
		<xsl:choose>
			<xsl:when test="//oddBackColor"><xsl:value-of select="//oddBackColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'#FFFFDD'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="oddBold" select="//oddBold/text() = 'true'"/>
	<xsl:variable name="oddItalic" select="//oddItalic/text() = 'true'"/>
	
	<xsl:variable name="makeHeader" select="/report/reportiter/@isFirst = 'true'"/>
	<xsl:variable name="makeFooter" select="/report/reportiter/@isLast = 'true'"/>

	<!-- Global variables }}} -->

	<xsl:template match="report">
		<xsl:apply-templates select="reportiter/ress"/>
	</xsl:template>

	<xsl:template match="ress">
		<xsl:if test="$makeHeader">
			<xsl:text disable-output-escaping="yes">	&lt;html&gt;</xsl:text>
			<head>
				<xsl:if test="not($EXPORTED_REPORT)">
					<link rel="stylesheet" href="/style/main.css" type="text/css"/>
					<script src="/js/modules/focus/print/gridpopup.js">1</script>
					<script>
						var processId = <xsl:text>'</xsl:text><xsl:value-of select="$processId"/><xsl:text>'</xsl:text>;
						var transletName = 'grid';
					</script>
				</xsl:if>
			</head>
			<xsl:text disable-output-escaping="yes">	&lt;body leftmargin="5" topmargin="5" marginheight="5" marginwidth="5" oncontextmenu="showGridMenu(); return false" style="background-color:#FFFFFF"&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;table border="0" cellspacing="1" class="gridTable" id="reportGrid"&gt;</xsl:text>
			<xsl:apply-templates select="res-header"/>
		</xsl:if>
		
		<xsl:apply-templates select="res"/>

		<xsl:if test="$makeFooter">
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<div id="ordermenu" style="width:100; overflow:visible; position:absolute; visibility:hidden; z-index:100" onMouseOut="outGridMenu()" onMouseOver="overGridMenu()"></div>
			<xsl:text disable-output-escaping="yes">	&lt;/body&gt;&lt;/html&gt;</xsl:text>
		</xsl:if>
	</xsl:template>

	<xsl:template match="res-header">
		<tr>
			<xsl:if test="$EXPORTED_REPORT">
				<xsl:attribute name="style">
					<xsl:value-of select="concat('font-family:', $headerFontName, '; font-size:', $headerFontSize, 'px; color:', $headerForeColor,'; background-color:', $headerBackColor,';font-weight:bold')"/>
					<xsl:text>;font-style:</xsl:text>
					<xsl:choose>
						<xsl:when test="$headerItalic">
							<xsl:text>italic</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>none</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="not($EXPORTED_REPORT)">
				<xsl:attribute name="class">headerRow</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="res-header-field"/>
		</tr>
	</xsl:template>

	<xsl:template match="res-header-field">
		<xsl:variable name="name" select="@name"/>
		<xsl:if test="@grid = 'true'">
			<td style="white-space:nowrap;">
				<xsl:variable name="sortorder" select="/report/reqs/req/req-entity[@sortfield = $name]/@sortdir"/>
				<xsl:choose>
					<xsl:when test="$sortorder = 'asc'">[A] </xsl:when>
					<xsl:when test="$sortorder = 'desc'">[D] </xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="@caption">
						<xsl:value-of select="@caption"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat(@entity, '__', @name)"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</xsl:if>		
	</xsl:template>

	<xsl:template match="res">
		<!-- get header fields -->
		<xsl:variable name="headerFields">
			<xsl:call-template name="getHeaderFields"/>
		</xsl:variable>
		<!-- call template in cycle -->
		<xsl:for-each select="res-record">
			<xsl:call-template name="resRecord">
				<xsl:with-param name="headerFields" select="$headerFields"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="resRecord">
		<xsl:param name="headerFields"/>
		<tr id="{@id}" style="background-color:white; color:black; font-family:Arial; font-size:12px;">
			<xsl:attribute name="style">
				<xsl:text>cursor:pointer; cursor:hand;</xsl:text>
				<xsl:choose>
					<xsl:when test="number(@id) mod 2">
						<xsl:value-of select="concat('background-color:', $oddBackColor, ';color:', $oddForeColor, ';font-family:', $oddFontName,';font-size:', $oddFontSize, ';font-weight:')"/>
						<xsl:choose>
							<xsl:when test="$oddBold">
								<xsl:text>bold</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>;font-style:</xsl:text>
						<xsl:choose>
							<xsl:when test="$oddItalic">
								<xsl:text>italic</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('background-color:', $evenBackColor, ';color:', $evenForeColor, ';font-family:', $evenFontName,';font-size:', $evenFontSize, ';font-weight:')"/>
						<xsl:choose>
							<xsl:when test="$evenBold">
								<xsl:text>bold</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>;font-style:</xsl:text>
						<xsl:choose>
							<xsl:when test="$evenItalic">
								<xsl:text>italic</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:for-each select="res-field">
				<xsl:call-template name="resField">
					<xsl:with-param name="headerFields" select="$headerFields"/>
				</xsl:call-template>
			</xsl:for-each>
		</tr>
	</xsl:template>

	<xsl:template name="resField">
		<xsl:param name="headerFields"/>

		<xsl:variable name="_id" select="concat(':', @name, ':')"/>
		<xsl:if test="contains($headerFields, $_id)">
			<td style="white-space:nowrap;">
				<xsl:choose>
					<xsl:when test="res-field-text">
						<xsl:value-of select="res-field-text/text()"/>
					</xsl:when>
					<xsl:when test="res-field-value">
						<xsl:value-of  select="res-field-value/text()"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&#160;</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getHeaderFields">
		<xsl:for-each select="/report/reportiter/ress/res-header/res-header-field">
			<xsl:if test="@grid = 'true'">
				<xsl:value-of select="concat(':', @name, ':')"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
