/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.error;

import com.queplix.core.utils.log.AbstractLogger;

/**
 * <p>Hepler class for exception handling</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:06 $
 */

public class ErrorHelper {

    /**
     * Throw GenericSystemException exception
     *
     * @param t      exception
     * @param logger AbstractLogger object
     */
    public static void throwSystemException(Throwable t,
                                            AbstractLogger logger) {
        throwSystemException(null, t, logger);
    }

    /**
     * Throw GenericSystemException exception
     *
     * @param msg    error message
     * @param t      exception
     * @param logger AbstractLogger object
     */
    public static void throwSystemException(String msg, Throwable t,
                                            AbstractLogger logger) {

        if(t == null) {
            if(msg != null) {
                throw new GenericSystemException(msg);
            } else {
                throw new GenericSystemException();
            }
        }

        if(logger != null) {
            if(msg != null) {
                logger.ERROR(msg, t);
            } else {
                logger.ERROR(t);
            }
        } else {
            if(msg != null) {
                System.err.println(msg);
            }
            t.printStackTrace();
        }

        if(t instanceof RuntimeException) {
            throw (RuntimeException) t;
        } else {
            if(msg != null) {
                throw new GenericSystemException(msg, t);
            } else {
                throw new GenericSystemException(t);
            }
        }
    }
}
