/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.error;

/**
 * Thrown when the parameter has an incorrect value.
 *
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:07 $2
 */

public class IncorrectParameterException
        extends javax.servlet.ServletException {

    /**
     * New exception with parameter name.
     *
     * @param name bad parameter name
     */
    public IncorrectParameterException(String name) {
        this(name, null);
    }

    /**
     * New exception with parameter name and bad value.
     *
     * @param name  bad parameter name
     * @param value bad value
     */
    public IncorrectParameterException(String name, String value) {
        this(name, value, null);
    }

    /**
     * New exception with parameter name and bad value.
     *
     * @param name     bad parameter name
     * @param value    bad value
     * @param comments additional comments
     */
    public IncorrectParameterException(String name, String value,
                                       String comments) {
        super("Incorrect parameter '" + name
                + ((value == null) ? "'":"'=" + value) +
                ((comments == null) ? "":". " + comments), null);
    }

}
