/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.integrator;

import com.queplix.core.integrator.security.LogonSession;

import javax.servlet.ServletContext;
import java.util.Map;

/**
 * This interface is used during the custom data loading
 *
 * @author Sergey Kozmin
 * @since 13.02.2007
 */
public interface CustomDataLoader {
    /**
     * This method initialize application specific parameters at the object {@link com.queplix.core.integrator.security.LogonSession}.
     * This method will be callded when user succesfully logon to the system.
     * Map of parameters stored in logon session object can contains any values objects.
     *
     * @param ls  initial logon session, that was created in core.
     * @param ctx servlet context.
     */
    public void loadServerCustomProperties(LogonSession ls, ServletContext ctx);

    /**
     * Collect application specific properties to be transferred to client side.
     * This method will be callded when user system builds metadata for user.
     *
     * @param ls  logon session
     * @param ctx servlet context
     * @return not null parameters map object.
     */
    public Map<String, String> loadClientCustomProperties(LogonSession ls,
                                                          ServletContext ctx);
}
