/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.integrator.entity;

/**
 * To be thrown when entity description has some inconsistency.
 * For example: pkey field doesn't specified in xml descriptor.
 *
 * @author Sergey Kozmin
 * @since 30.10.2006, 11:46:47
 */
class IncorrectEntityDescriptionException extends RuntimeException {
    private String entityName;

    public IncorrectEntityDescriptionException(String entityName) {
        this.entityName = entityName;
    }

    public IncorrectEntityDescriptionException(String entityName,
                                               String message) {
        super(message);
        this.entityName = entityName;
    }

    public IncorrectEntityDescriptionException(String entityName,
                                               String message,
                                               Throwable cause) {
        super(message, cause);
        this.entityName = entityName;
    }

    public IncorrectEntityDescriptionException(String entityName,
                                               Throwable cause) {
        super(cause);
        this.entityName = entityName;
    }

    public String getEntityName() {
        return entityName;
    }
}
