/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.integrator.entity;

import com.queplix.core.client.app.vo.FieldData;

import java.util.HashMap;
import java.util.Map;

/**
 * One record of the {@link IntegratedRecordSet}
 *
 * @author Sergey Kozmin
 * @since 21.11.2006, 19:20:26
 */
public class IntegratedRecord {
    private Map<String, FieldData> fieldSet;

    public IntegratedRecord(Map<String, FieldData> fieldSet) {
        if(fieldSet != null) {
            this.fieldSet = fieldSet;
        } else {
            this.fieldSet = new HashMap<String, FieldData>();
        }
    }

    public IntegratedRecord() {
        this(null);
    }

    public Map<String, FieldData> getFieldSet() {
        return fieldSet;
    }
}
