/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.integrator.entity;

import com.queplix.core.client.app.vo.FieldMeta;
import com.queplix.core.modules.eqlext.GetRecordsRes;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Represents result of any core2.6 request, but include dataset in it.
 *
 * @author Sergey Kozmin
 * @see com.queplix.core.integrator.EntityFacade to know how to get this object.
 * @since 21.11.2006, 18:50:19
 */
public class IntegratedRecordSet {
    private String pkeyFieldName;
    private String listRefFieldName;
    private List<IntegratedRecord> recordSet;
    private Map<String, FieldMeta> recordMeta;
    private Set<String> gridFields;
    private GetRecordsRes initialResultSet;

    public IntegratedRecordSet(String pkeyFieldName, String listRefFieldName,
                               List<IntegratedRecord> recordSet,
                               Map<String, FieldMeta> recordMeta,
                               GetRecordsRes initialResultSet,
                               Set<String> gridFields) {
        this.listRefFieldName = listRefFieldName;
        this.initialResultSet = initialResultSet;
        this.pkeyFieldName = pkeyFieldName;
        if(recordSet != null) {
            this.recordSet = recordSet;
        } else {
            this.recordSet = new LinkedList<IntegratedRecord>();
        }
        if(recordMeta != null) {
            this.recordMeta = recordMeta;
        } else {
            this.recordMeta = new HashMap<String, FieldMeta>();
        }
        if(gridFields != null) {
            this.gridFields = gridFields;
        } else {
            this.gridFields = new LinkedHashSet<String>();
        }
    }

    public IntegratedRecordSet() {
        this("", "", null, null, null, null);
    }

    public int getRowsCount() {
        return recordSet.size();
    }

    public String getPkeyFieldName() {
        return pkeyFieldName;
    }

    public String getListRefFieldName() {
        return listRefFieldName;
    }

    public List<IntegratedRecord> getRecordSet() {
        return recordSet;
    }

    public Map<String, FieldMeta> getRecordMeta() {
        return recordMeta;
    }

    /**
     * can be null
     *
     * @return initial result set
     */
    public GetRecordsRes getInitialResultSet() {
        return initialResultSet;
    }

    public Set<String> getGridFields() {
        return gridFields;
    }
}
