/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.integrator.entity;

import com.queplix.core.client.app.vo.SortField;

/**
 * Class represent all request properties container.
 *
 * @author Sergey Kozmin
 * @since 22.11.2006, 11:07:42
 */
public class RequestProperties {
    private boolean isDoCount = true;
    /**
     * false by default, because it takes half of server time to perform request. Since we have 3.0 wrapper
     * no need to generate headers except of reports generating.
     */
    private boolean isDoHeader = false;
    private boolean isGetRequest = true;
    /**
     * This parameter tells eql engine to ignore "sendonrequest" parameter in entity description. It
     * was used to optimize fields when user search records in grid and we knew that that fields will not go to grid. Now
     * user has customizable grid and we need dynamic way to change requested field. But for now we don't know requested
     * fields and request simply all fields. So, this parameter is always true now.
     */
    private boolean isIgnoreSendOnRequest = true;
    private int page = -1;
    private int pagesize = 20;
    private SortField sortField;

    /**
     * Describes the logic operations between entities, included to request.
     */
    private LogicalOperations operation = LogicalOperations.AND;

    public RequestProperties(boolean doCount, int page, int pagesize,
                             SortField sortField) {
        setDoCount(doCount);
        this.page = page;
        this.pagesize = pagesize;
        this.sortField = sortField;
    }

    public RequestProperties() {
    }

    public boolean isDoCount() {
        return isDoCount;
    }

    public void setDoCount(boolean doCount) {
        isDoCount
                = doCount;    //todo remove it if causes performance problems. Need to know how many records, to perform paging functionality.
    }

    public boolean isDoHeader() {
        return isDoHeader;
    }

    public void setDoHeader(boolean doHeader) {
        isDoHeader = doHeader;
    }

    public boolean isGetRequest() {
        return isGetRequest;
    }

    public void setGetRequest(boolean getRequest) {
        isGetRequest = getRequest;
    }

    public boolean isIgnoreSendOnRequest() {
        return isIgnoreSendOnRequest;
    }

    public void setIgnoreSendOnRequest(boolean ignoreSendOnRequest) {
        isIgnoreSendOnRequest = ignoreSendOnRequest;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPagesize() {
        return pagesize;
    }

    public void setPagesize(int pagesize) {
        this.pagesize = pagesize;
    }

    public SortField getSortField() {
        return sortField;
    }

    public void setSortField(SortField sortField) {
        this.sortField = sortField;
    }

    public LogicalOperations getOperation() {
        return operation;
    }

    public void setOperation(LogicalOperations operation) {
        this.operation = operation;
    }
}
