/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.integrator.security;

/**
 * Security role VO class
 *
 * @author Kozmin Sergey
 * @since 16.01.2007
 */

public class Role {
    // Primary data.
    private long roleID;
    private String roleName;
    private String defaultFocus;

    public Role(long roleID, String roleName, String defaultFocus) {
        this.roleID = roleID;
        this.roleName = roleName;
        this.defaultFocus = defaultFocus;
    }


    public long getRoleID() {
        return roleID;
    }

    public void setRoleID(long roleID) {
        this.roleID = roleID;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getDefaultFocus() {
        return defaultFocus;
    }

    public void setDefaultFocus(String defaultFocus) {
        this.defaultFocus = defaultFocus;
    }

    public boolean equals(Object obj) {
        return obj == this || (obj instanceof Role) && (((Role) obj).roleID
                == roleID);

    }

    public int hashCode() {
        return (int) roleID;
    }

    public String toString() {
        return "id=" + roleID + "; name=" + roleName + "; defaultFocus="
                + defaultFocus;
    }
}
