/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.integrator.security;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * User VO class
 *
 * @author Kozmin Sergey
 * @since 16.01.2007
 */

public class User implements Serializable {
    private long userID;
    private String loginName;
    private String fullName;
    private String passwordDigest;
    private String langID;
    private String countryID;
    private String timeZoneID;
    /**
     * date pattern for user or default date pattern
     */
    private String datePattern;
    /**
     * time pattern for user or default date pattern
     */
    private String timePattern;
    /**
     * Date position
     */
    private boolean isDatePositionFirst;
    private int authenticationType;
    private List<Long> userGroups;
    private Set<Long> rolesIDs;
    private String email;
    private String defaultFocus;
    private int userType;
    public static final int NOTIFY_METHOD_ALERT = 0;
    public static final int NOTIFY_METHOD_EMAIL = 1;

    public User(long userID, String loginName, String fullName,
                String passwordDigest, String langID, String countryID,
                String timeZoneID, String datePattern, String timePattern,
                boolean isDatePositionFirst, int authenticationType,
                List<Long> userGroups, Set<Long> rolesIDs, String email) {
        this.userID = userID;
        this.loginName = loginName;
        this.fullName = fullName;
        this.passwordDigest = passwordDigest;
        this.langID = langID;
        this.countryID = countryID;
        this.timeZoneID = timeZoneID;
        this.datePattern = datePattern;
        this.timePattern = timePattern;
        this.isDatePositionFirst = isDatePositionFirst;
        this.authenticationType = authenticationType;
        this.userGroups = userGroups;
        this.rolesIDs = rolesIDs;
        this.email = email;
        this.userType = 0;
    }

    public User(long userID, String loginName, String passwordDigest) {
        this();
        this.userID = userID;
        this.loginName = loginName;
        this.passwordDigest = passwordDigest;
    }

    public User() {
    }

    public long getUserID() { //
        return userID;
    }

    public void setUserID(long userID) {
        this.userID = userID;
    }

    public String getLoginName() { //
        return loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getFullName() { //
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPasswordDigest() { //
        return passwordDigest;
    }

    public void setPasswordDigest(String passwordDigest) {
        this.passwordDigest = passwordDigest;
    }

    public String getLangID() { //
        return langID;
    }

    public void setLangID(String langID) {
        this.langID = langID;
    }

    public String getCountryID() { //
        return countryID;
    }

    public void setCountryID(String countryID) {
        this.countryID = countryID;
    }

    public int getAuthenticationType() { //?
        return authenticationType;
    }

    public void setAuthenticationType(int authenticationType) {
        this.authenticationType = authenticationType;
    }

    public List<Long> getUserGroups() { //-
        return userGroups;
    }

    public void setUserGroups(List<Long> userGroups) {
        this.userGroups = userGroups;
    }

    /**
     * @return distinct roles, that holds this user, included those which set to
     *         him through the workgroups
     */
    public Set<Long> getRolesIDs() {
        return rolesIDs;
    }

    public void setRolesIDs(Set<Long> rolesIDs) {
        this.rolesIDs = rolesIDs;
    }

    public String getEmail() { //
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public int getUserType() { //
        return userType;
    }

    public void setUserType(int type) {
        this.userType = type;
    }

    public String getTimeZoneID() { //
        return timeZoneID;
    }

    public void setTimeZoneID(String timeZoneID) {
        this.timeZoneID = timeZoneID;
    }

    public String getDatePattern() { //
        return datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public String getTimePattern() { //
        return timePattern;
    }

    public void setTimePattern(String timePattern) {
        this.timePattern = timePattern;
    }

    public boolean isDatePositionFirst() { //
        return isDatePositionFirst;
    }

    public void setDatePositionFirst(boolean datePositionFirst) {
        isDatePositionFirst = datePositionFirst;
    }

    public boolean equals(Object obj) {
        if(obj == null || !(obj instanceof User)) {
            return false;
        }
        User vo = (User) obj;
        return vo.getUserID() == getUserID();
    }

    public int hashCode() {
        return ((int) getUserID());
    }

    public String toString() {
        return "User{" +
                "userID=" + userID +
                ", loginName='" + loginName + '\'' +
                ", fullName='" + fullName + '\'' +
                ", passwordDigest='" + passwordDigest + '\'' +
                ", langID='" + langID + '\'' +
                ", countryID='" + countryID + '\'' +
                ", timeZoneID='" + timeZoneID + '\'' +
                ", datePattern='" + datePattern + '\'' +
                ", timePattern='" + timePattern + '\'' +
                ", isDatePositionFirst=" + isDatePositionFirst +
                ", authenticationType=" + authenticationType +
                ", userGroups=" + userGroups +
                ", rolesIDs=" + rolesIDs +
                ", email='" + email + '\'' +
                ", defaultFocus='" + defaultFocus + '\'' +
                '}';
    }

    public String getDefaultFocus() {
        return defaultFocus;
    }

    public void setDefaultFocus(String defaultFocus) {
        this.defaultFocus = defaultFocus;
    }

}
