/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.integrator.util;

import com.queplix.core.client.app.vo.EntityData;
import com.queplix.core.client.app.vo.EntityElement;

import java.util.Collections;
import java.util.List;


/**
 * Adhoc report object
 *
 * @author Sergey Kozmin
 * @since 23.03.2007
 */
public class AdhocReport {
    private List<EntityElement> reportFields;
    private List<EntityData> filters;

    public AdhocReport(List<EntityElement> reportFields,
                       List<EntityData> filters) {
        setFilters(filters);
        setReportFields(reportFields);
    }

    public List<EntityElement> getReportFields() {
        return reportFields;
    }

    public void setReportFields(List<EntityElement> reportFields) {
        if(reportFields != null) {
            this.reportFields = reportFields;
        } else {
            this.reportFields = Collections.emptyList();
        }
    }

    public List<EntityData> getFilters() {
        return filters;
    }

    public void setFilters(List<EntityData> filters) {
        if(filters != null) {
            this.filters = filters;
        } else {
            this.filters = Collections.emptyList();
        }
    }
}
