/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.alert.utils;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.modules.alert.jxb.AlertConfig;
import com.queplix.core.utils.cache.CacheFactory;
import com.queplix.core.utils.dao.AbstractPropertyFactory;

/**
 * Alert property access factory
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.2 $ $Date: 2005/10/26 14:03:51 $
 */

public final class AlertPropertyFactory
        extends AbstractPropertyFactory {

    // ================================================================= Constants

    // Single instance.
    private static final AlertPropertyFactory o = new AlertPropertyFactory();

    // Config file name.
    private static final String CONFIG_FILE = "alert.xml";

    // ================================================================= Fields

    // XML alert config
    private AlertConfig alertConfig;

    // DAO cached class.
    private AlertDAO alertDAO;

    // Selector cached classes.
    private AlertSelector alertSelector;

    // Cache cached classes.
    private AlertCache alertCache;

    // ===================================================== Constructor

    // Constructor - blocks direct instantiation.

    private AlertPropertyFactory() {

        // XML config initialization
        alertConfig = (AlertConfig) loadSysPropertiesAsObject(CONFIG_FILE,
                AlertConfig.class);

        //
        // DAO initialization
        //

        alertDAO = (AlertDAO) initObject(alertConfig.getDao().getClassName(),
                alertConfig.getDao().getParam());

        //
        // Selector initialization
        //

        alertSelector = (AlertSelector) initObject(
                alertConfig.getSelector().getClassName(),
                alertConfig.getSelector().getParam());

        //
        // Cache initialization
        //

        alertCache = (AlertCache) CacheFactory.getInstance().initObject(
                alertConfig.getCache().getClassName(),
                alertConfig.getCache().getParam());
    }

    // ===================================================== Static methods

    /**
     * Get single instance
     *
     * @return AlertPropertyFactory object
     */
    public static AlertPropertyFactory getInstance() {
        return o;
    }

    // ===================================================== Public methods

    /**
     * Instantiates the alert DAO
     *
     * @return alert DAO
     */
    public AlertDAO getAlertDAO() {
        if(alertDAO == null) {
            throw new GenericSystemException("Can't get alert DAO");
        }

        return alertDAO;
    }

    /**
     * Instantiates the alert selector
     *
     * @return alert selector
     */
    public AlertSelector getAlertSelector() {
        if(alertSelector == null) {
            throw new GenericSystemException("Can't get alert selector");
        }

        return alertSelector;
    }

    /**
     * Instantiates the alert cache
     *
     * @return cache
     */
    public AlertCache getAlertCache() {
        if(alertCache == null) {
            throw new GenericSystemException("Can't get alert cache");
        }
        return alertCache;
    }

}
