/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.alert.utils;

import com.queplix.core.utils.cache.Cache;
import com.queplix.core.utils.dao.InterfaceProperty;

import java.util.SortedMap;

/**
 * Alert selector interface. Used to select alerts from the cache using search criteria.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:08 $
 */

public interface AlertSelector
        extends InterfaceProperty {

    /**
     * Searches alerts in the cache <code>cache</code>.
     *
     * @param cache    alerts cache
     * @param criteria search criteria
     * @return sorted map of Alert objects
     * @see Alert
     */
    SortedMap search(Cache cache, AlertSelectorCriteria criteria);
}
