/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.config.actions;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.modules.config.ejb.PortalConfigManager;
import com.queplix.core.modules.config.ejb.PortalConfigManagerHome;
import com.queplix.core.modules.config.jxb.portal.PortalConfigs;
import com.queplix.core.modules.services.Action;
import com.queplix.core.modules.services.ServiceStartupManager;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.xml.XMLBinding;
import com.queplix.core.utils.xml.XMLFactory;
import com.queplix.core.utils.xml.XMLWrapper;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.w3c.dom.Document;

/**
 *
 * @author dmitry.antonov
 */
public class PortalConfigInstallationAction extends Action {
    
    private XMLWrapper xmlWrapper = XMLFactory.getXMLWrapper();
    private XMLBinding xmlBinding = XMLFactory.getXMLBinding();
    
    public Serializable perform() {
        File portalConfigFile = (File) getContext().
            getParameter(ServiceStartupManager.PORTAL_CONFIG_FILE_PARAM);
        if (portalConfigFile != null) {
            try {
                INFO("PROCESS STARTED...");
                long time = System.currentTimeMillis();
                PortalConfigs configs = parseConfig(portalConfigFile);
                INFO("parse portal configs - ok");

                deployConfigs(configs);
                INFO("deploy portal configs - ok");

                INFO("Process last(s): " 
                    + (System.currentTimeMillis() - time) / 1000);
                INFO("PROCESS DONE !!!");
            }
            catch(Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
    
    private PortalConfigs parseConfig(File portalConfigFile) {
        Document document = xmlWrapper.getDocument(portalConfigFile, false);
        return (PortalConfigs) xmlBinding.xmlToJava(PortalConfigs.class, document);
    }

    private void deployConfigs(PortalConfigs configs) {
        try {
            getPortalConfigManager().fillPortalConfigs(configs);
        }
        catch(RemoteException e) {
            throw new GenericSystemException("Remote exception " + e.
                getMessage(), e);
        }
    }
    
    /**
     * Get FocusConfigManager EJB reference
     *
     * @return FocusConfigManager remote interface
     */
    private PortalConfigManager getPortalConfigManager() {
        return (PortalConfigManager)
                getContext().getCOM().getRemoteObject(
                        JNDINames.PortalConfigManagerRemote,
                        PortalConfigManagerHome.class);
    }
    
}
