/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */


package com.queplix.core.modules.config.ejb;

import com.queplix.core.modules.config.jxb.portal.PortalConfig;
import com.queplix.core.modules.config.jxb.portal.PortalConfigs;
import com.queplix.core.modules.config.utils.ConfigPropertyFactory;
import com.queplix.core.utils.cache.Cache;
import com.queplix.core.utils.ejb.AbstractSessionEJB;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;

/**
 *
 * @author dmitry.antonov
 */
public class PortalConfigManagerEJB extends AbstractSessionEJB {
    
    public void fillPortalConfigs(PortalConfigs configs) {
        long time = System.currentTimeMillis();
        INFO("Try to fill portal configs objects");
        
        //clearing the cache
        Cache cache = ConfigPropertyFactory.getInstance().getPortalConfigsCache();
        cache.clear();
        ConfigPropertyFactory.getInstance().getPortalConfigsDAO().deletePortalConfigs();
        ConfigPropertyFactory.getInstance().getPortalConfigsDAO().fillPortalConfigs(configs);
        
        INFO("Fill all portal configs - ok. Count " + 
            configs.getPortalConfigCount() + ". Time (ms): " + 
            (System.currentTimeMillis() - time));
    }
    
    public PortalConfig getPortalConfig(String portalName) {
        Cache cache = ConfigPropertyFactory.getInstance().getPortalConfigsCache();
        PortalConfig portalConfig = (PortalConfig) cache.get(portalName);
        
        if (portalConfig == null) {
            // Load record from database.
            portalConfig = ConfigPropertyFactory.getInstance().
                getPortalConfigsDAO().loadConfigByName(portalName);

            // Store in cache.
            cache.put(portalName, portalConfig);
        }
        return portalConfig;
    }
    
    /**
     * Initialize bean
     */
    public void ejbCreate() {
        INFO("FocusConfigManagerEJB create - " + hashCode());
    }
    
}
