/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.config.error;

import com.queplix.core.error.GenericSystemException;

/**
 * <p>Throws when entity not found</p>
 *
 * @author [ALB] Baranov L. Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:15 $
 */

public class UnknownEntityException
        extends GenericSystemException {

    /**
     * Constructor
     */
    public UnknownEntityException() {
        super("No entities");
    }

    /**
     * Constructor
     *
     * @param name entity name
     */
    public UnknownEntityException(String name) {
        this(name, null);
    }

    /**
     * Constructs
     *
     * @param name    entity name
     * @param message the detail message
     */
    public UnknownEntityException(String name, String message) {
        super("No such entity '" + name + "'. " +
                (message == null ? "":message));
    }
}