/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.modules.config.utils;

/**
 * @author Alexander Melnik
 * @since 18 April 2007
 */
public class FormSettingDefImpl implements FormSetting {
    private boolean minimized;
    private String formID;

    public FormSettingDefImpl() {
    }

    public FormSettingDefImpl(String formID, boolean minimized) {
        this.formID = formID;
        this.minimized = minimized;
    }

    public void initialize(String formID, boolean minimized) {
        this.formID = formID;
        this.minimized = minimized;
    }

    public String getFormID() {
        return formID;
    }

    public boolean isMinimized() {
        return minimized;
    }

    public void setFormID(String formID) {
        this.formID = formID;
    }

    public void setMinimized(boolean minimized) {
        this.minimized = minimized;
    }

}
