/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.config.utils;

import com.queplix.core.modules.config.jxb.portal.PortalConfig;
import com.queplix.core.modules.config.jxb.portal.PortalConfigs;
import com.queplix.core.utils.dao.InterfaceDAO;

/**
 * Was intended for Portal Configurations management.
 * @author dmitry.antonov
 */
public interface PortalConfigsDAO extends InterfaceDAO {
    
    /**
     * Deletes all portal configurations.
     */
    void deletePortalConfigs();
    
    /**
     * Fills portal configurations in database.
     */
    void fillPortalConfigs(PortalConfigs configs);
    
    /**
     * Loads and returns portal configuration using specified name.
     */
    PortalConfig loadConfigByName(String portalName);
    
}
