/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */


package com.queplix.core.modules.config.utils.db;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.modules.config.jxb.portal.Control;
import com.queplix.core.modules.config.jxb.portal.Css;
import com.queplix.core.modules.config.jxb.portal.MainToolbar;
import com.queplix.core.modules.config.jxb.portal.Menus;
import com.queplix.core.modules.config.jxb.portal.PortalConfig;
import com.queplix.core.modules.config.jxb.portal.PortalConfigs;
import com.queplix.core.modules.config.utils.PortalConfigsDAO;
import com.queplix.core.utils.dao.AbstractDAO;
import com.queplix.core.utils.sql.SqlWrapper;
import com.queplix.core.utils.sql.SqlWrapperFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 *
 * @author dmitry.antonov
 */
public class PortalConfgisDAOImpl extends AbstractDAO 
    implements PortalConfigsDAO {
    
    private final SqlWrapper sqlWrapper = SqlWrapperFactory.getSqlWrapper();
    
    public void deletePortalConfigs() {
        Connection con = sqlWrapper.doConnection();
        Statement st = sqlWrapper.doStatement(con);
        try {
            sqlWrapper.executeUpdate(st, 
                DBRealmManager.getSql("delall_portal_toolbar"));
            sqlWrapper.executeUpdate(st,
                DBRealmManager.getSql("delall_portal_config"));
        }
        catch(SQLException e) {
            throw new GenericSystemException("SQL Exception " + e.getMessage(), 
                e);
        }
        finally {
            sqlWrapper.closeConnection(con);
        }
    }

    public void fillPortalConfigs(PortalConfigs configs) {
        Connection con = sqlWrapper.doConnection();
        PreparedStatement configPs = sqlWrapper.doPreparedStatement(con, 
            DBRealmManager.getSql("insert_portal_config"));
        PreparedStatement toolbarPs = sqlWrapper.doPreparedStatement(con,
            DBRealmManager.getSql("insert_portal_toolbar_item"));
        try {
            for (PortalConfig config: configs.getPortalConfig()) {
                sqlWrapper.getStringParser().setValue(configPs, 1, config.getName());
                String cssFilename = config.getCss() != null ? 
                                        config.getCss().getFilename() : null;
                sqlWrapper.getStringParser().setValue(configPs, 2, cssFilename);
                sqlWrapper.getIntParser().setValue(configPs, 3, 
                    config.getMenus().getShowFocusMenu() ? 1 : 0);
                sqlWrapper.getIntParser().setValue(configPs, 4, 
                    config.getMenus().getShowSubfocusMenu() ? 1 : 0);
                sqlWrapper.executeUpdate(configPs);
                fillToolbar(toolbarPs, config, config.getMainToolbar());
            }
        }
        catch(SQLException e) {
            throw new GenericSystemException("SQL Exception " + e.getMessage(), 
                e);
        }
        finally {
            sqlWrapper.closeConnection(con);
        }
    }
    
    private void fillToolbar(PreparedStatement ps, PortalConfig config, 
        MainToolbar toolbar) throws SQLException {
        if (toolbar != null) {
            int order = 0;
            for (Control item : toolbar.getControl()) {
                sqlWrapper.getStringParser().setValue(ps, 1, config.getName());
                sqlWrapper.getIntParser().setValue(ps, 2, order++);
                sqlWrapper.getStringParser().setValue(ps, 3, item.getName());
                sqlWrapper.executeUpdate(ps);
            }
        }
    }

    public PortalConfig loadConfigByName(String portalName) {
        PortalConfig config = new PortalConfig();
        Connection con = sqlWrapper.doConnection();
        PreparedStatement readConfig = sqlWrapper.doPreparedStatement(con,
            DBRealmManager.getSql("select_portal_config"));
        PreparedStatement readToolbar = sqlWrapper.doPreparedStatement(con, 
            DBRealmManager.getSql("select_portal_toolbar"));
        try {
            sqlWrapper.getStringParser().setValue(readConfig, 1, portalName);
            ResultSet rs = sqlWrapper.executeQuery(readConfig);
            while (rs.next()) {
                String cssFilename = sqlWrapper.getStringParser().getValue(rs, 1);
                if (cssFilename != null) {
                    Css css = new Css();
                    css.setFilename(cssFilename);
                    config.setCss(css);
                }
                Menus menus = new Menus();
                if (sqlWrapper.getIntParser().getValue(rs, 2) > 0) {
                    menus.setShowFocusMenu(true);
                } else {
                    menus.setShowFocusMenu(false);
                }
                if (sqlWrapper.getIntParser().getValue(rs, 3) > 0) {
                    menus.setShowSubfocusMenu(true);
                } else {
                    menus.setShowSubfocusMenu(false);
                }
                config.setMenus(menus);
                config.setMainToolbar(loadToolbar(readToolbar, portalName));
            }
        }
        catch(SQLException e) {
            throw new GenericSystemException("SQL Exception " + e.getMessage(),
                e);
        }
        finally {
            sqlWrapper.closeConnection(con);
        }
        return config;
    }

    private MainToolbar loadToolbar(PreparedStatement readToolbar, 
                                    String portalName) throws SQLException {
        MainToolbar toolbar = new MainToolbar();
        sqlWrapper.getStringParser().setValue(readToolbar, 1, portalName);
        ResultSet rs = sqlWrapper.executeQuery(readToolbar);
        while (rs.next()) {
            Control control = new Control();
            control.setName(sqlWrapper.getStringParser().getValue(rs, 1));
            toolbar.addControl(control);
        }
        return toolbar;
    }
    
}
