/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.config.utils.ejb;

import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.config.ejb.CaptionManagerLocal;
import com.queplix.core.modules.config.ejb.CaptionManagerLocalHome;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocal;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocalHome;
import com.queplix.core.modules.config.jxb.Custom;
import com.queplix.core.modules.config.jxb.CustomField;
import com.queplix.core.modules.config.utils.CustomConfigDAO;
import com.queplix.core.modules.config.utils.CustomID;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.cache.CacheObjectManager;
import com.queplix.core.utils.dao.AbstractDAO;

/**
 * Project-specific implementation of the CustomConfigDAO
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:18 $
 */

public class CustomConfigDAOImpl
        extends AbstractDAO implements CustomConfigDAO {

    // --------------------------------------------------------------- Overrided Methods

    /*
     * No javadoc
     * @see CustomConfigDAO#CustomConfigDAO
     */

    public int storeCustomsVO(Custom[] customs) {

        CaptionManagerLocal local = getCaptionManagerLocal();
        int updated = 0;

        // Read Custom in cycle.
        for(int i = 0; i < customs.length; i++) {
            Custom custom = customs[i];

            // Read CustomField in cycle.
            for(int j = 0; j < custom.getCustomFieldCount(); j++) {
                CustomField customField = custom.getCustomField(j);

                // Fill field captions.
                local.fillEfieldCaptions(custom.getEntity(),
                        customField.getEfield(),
                        customField.getCaptions());

                updated++;
            }
        }

        return updated;
    }

    /*
     * No javadoc
     * @see CustomConfigDAO#loadCustomVO
     */
    public Custom loadCustomVO(CustomID customID) {

        // Init.
        String entityName = customID.getEntityName();
        String langId = customID.getLangId();
        CaptionManagerLocal local = getCaptionManagerLocal();

        // Get entity.
        Entity entity = getEntityViewConfigManagerLocal().getEntityViewConfig(
                entityName);

        // Build Custom.
        Custom custom = new Custom();
        custom.setEntity(entityName);

        // 1) Get field customs.
        int size = entity.getEfieldCount();
        for(int i = 0; i < size; i++) {
            String fieldName = entity.getEfield(i).getName();

            // .. build CustomField object
            CustomField customField = new CustomField();
            customField.setEfield(fieldName);
            customField.setCaption(local.getEfieldCaption(langId, entityName,
                    fieldName));

            // .. remember reference
            custom.addCustomField(customField);
            custom.putObject(fieldName, customField);
        }

        // 1) Get dataset customs.
        size = entity.getDatasetCount();
        for(int i = 0; i < size; i++) {
            String datasetName = entity.getDataset(i).getName();

            // .. build CustomField object
            CustomField customField = new CustomField();
            customField.setEfield(datasetName);
            customField.setCaption(local.getEfieldCaption(langId, entityName,
                    datasetName));

            // .. remember reference
            custom.addCustomField(customField);
            custom.putObject(datasetName, customField);
        }

        return custom;
    }

    //---------------------------------------------------------------- Private methods

    /**
     * Gets EntityViewConfigManager EJB local interface.
     *
     * @return local interface
     */
    private EntityViewConfigManagerLocal getEntityViewConfigManagerLocal() {
        return (EntityViewConfigManagerLocal) new CacheObjectManager().
                getLocalObject(JNDINames.EntityViewConfigManager,
                        EntityViewConfigManagerLocalHome.class);
    }

    /**
     * Gets CaptionManager EJB local interface.
     *
     * @return local interface
     */
    private CaptionManagerLocal getCaptionManagerLocal() {
        return (CaptionManagerLocal) new CacheObjectManager().
                getLocalObject(JNDINames.CaptionManager,
                        CaptionManagerLocalHome.class);
    }
}
