/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql;

import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.config.utils.EntityHelper;

/**
 * <p>EQL entity response object</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:19 $
 */

public class EQLERes
        extends EQLRes {

    // ------------------------------------------------------- variables

    private Entity entity;

    // ------------------------------------------------------- constructor

    public EQLERes(Entity entity) {
        this.entity = entity;
    }

    // ------------------------------------------------------- public methods

    // Get base entity.

    public Entity getEntity() {
        return entity;
    }

    // Contains.
    public boolean contains(EQLResRecord record) {

        Efield[] pkeys = EntityHelper.getPkeys(entity);
        if(pkeys == null) {
            return getRecords().contains(record);
        }

        for(int i = 0; i < size(); i++) {
            EQLResRecord __record = getRecord(i);

            // compare only pkeys
            boolean equals = false;
            for(int j = 0; j < pkeys.length; j++) {
                EQLReqField reqField = new EQLReqField(entity, pkeys[j]);
                EQLResCell cell = record.getResCell(reqField);
                EQLResCell __cell = __record.getResCell(reqField);

                if((cell == null && __cell == null) ||
                        (cell != null && __cell != null && cell.equals(
                                __cell))) {
                    equals = true;
                } else {
                    equals = false;
                    break;
                }
            }

            if(equals) {
                return true;
            }
        }

        return false;
    }

    // Hash code.
    public int hashCode() {
        return entity.hashCode();
    }

    // Equals.
    public boolean equals(Object o) {
        if(o == null) {
            return false;
        }

        if(o == this) {
            return true;
        }

        if(o instanceof EQLERes) {
            EQLERes eRes = (EQLERes) o;
            return entity.getName().equals(eRes.getEntity().getName());
        }

        return false;
    }

    // To string.
    public String toString() {
        return "entity response: " + entity.getName();
    }
}
