/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql;

import com.queplix.core.modules.eql.ops.NoneOp;

import java.util.ArrayList;

/**
 * <p>EQL Request Operation object</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public class EQLReqOp
        implements EQLReqSubOpMember, java.io.Serializable {

    private ArrayList subOps = new ArrayList();

    public EQLReqOp() {
    }

    public EQLReqOp(EQLReqField reqField) {
        if(reqField == null) {
            throw new IllegalStateException();
        }

        addSubOp(new NoneOp(new EQLReqSubOpMemberField(reqField)));
    }

    public EQLReqOp(EQLReqSubOpMember member) {
        if(member == null) {
            throw new IllegalStateException();
        }

        addSubOp(new NoneOp(member));
    }

    public void addSubOp(EQLReqSubOp subOp) {
        subOps.add(subOp);
    }

    public ArrayList getSubOps() {
        return subOps;
    }

    public EQLReqSubOp getSubOp(int i) {
        return (EQLReqSubOp) subOps.get(i);
    }

    public int size() {
        return subOps.size();
    }

    public int hashCode() {
        return subOps.hashCode();
    }

    public boolean equals(Object o) {
        if(!(o instanceof EQLReqOp)) {
            return false;
        }

        if(o == this) {
            return true;
        }

        EQLReqOp reqOp = (EQLReqOp) o;
        return subOps.equals(reqOp.getSubOps());
    }

    public String toString() {
        return "op=" + getClass().getName() + " subops=" + subOps;
    }
}
