/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql;

/**
 * <p>EQL Request Sub Where object</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:21 $
 */

public class EQLReqSubWhere implements java.io.Serializable {

    // All where operation ids
    public static final int NONE_OP = -1;
    public static final int AND_OP = 1;
    public static final int OR_OP = 2;

    private int op;
    private java.io.Serializable cond;

    public EQLReqSubWhere(int op, EQLReqSubWhereCond subWhereCond) {
        this.op = op;
        this.cond = subWhereCond;
    }

    public EQLReqSubWhere(int op, EQLReqWhere where) {
        this.op = op;
        this.cond = where;
    }

    public java.io.Serializable getCond() {
        return cond;
    }

    public int getOperation() {
        return op;
    }

    public int hashCode() {
        return op | cond.hashCode();
    }

    public boolean equals(Object o) {
        if(!(o instanceof EQLReqSubWhere)) {
            return false;
        }

        if(o == this) {
            return true;
        }

        EQLReqSubWhere subWhere = (EQLReqSubWhere) o;
        return (op == subWhere.getOperation()) && cond.equals(
                subWhere.getCond());
    }
}
