/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>EQL response object</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:21 $
 */

public class EQLRes
        implements java.io.Serializable {

    // ------------------------------------------------------- variables

    // List of EQLResRecord objects.
    private List records;

    // Response meta-data.
    private EQLResMetaData metaData;

    // ------------------------------------------------------- constructor

    public EQLRes() {
        records = new ArrayList(20);
    }

    public EQLRes(int size) {
        records = new ArrayList(size);
    }

    // ------------------------------------------------------- public methods

    public EQLResMetaData getMetaData() {
        synchronized(records) {
            if(metaData == null) {
                metaData = new EQLResMetaData();
            }
        }
        return metaData;
    }

    public void setMetaData(EQLResMetaData metaData) {
        this.metaData = metaData;
    }

    public boolean isEmpty() {
        return size() == 0;
    }

    public List getRecords() {
        return records;
    }

    public int size() {
        return records.size();
    }

    public EQLResRecord getRecord(int recordNum) {
        return (EQLResRecord) records.get(recordNum);
    }

    public void addRecord(EQLResRecord record) {
        records.add(record);
    }

    public void addRecord(EQLResRecord record, int index) {
        records.add(index, record);
    }

    public void removeRecord(EQLResRecord record) {
        records.remove(record);
    }

    // mark all records to delete
    public void markAllAsDelete() {
        for(int i = 0; i < records.size(); i++) {
            EQLResRecord resRecord = getRecord(i);
            resRecord.markAsDelete();
        }
    }

    // mark all records to update
    // @todo do we really need it?
    public void markAllAsUpdate() {
        for(int i = 0; i < records.size(); i++) {
            EQLResRecord resRecord = getRecord(i);
            resRecord.markAsUpdate();
        }
    }

    // mark all records to insert
    public void markAllAsInsert() {
        for(int i = 0; i < records.size(); i++) {
            EQLResRecord resRecord = getRecord(i);
            resRecord.markAsInsert();
        }
    }

    // hash code
    public int hashCode() {
        return records.hashCode() | metaData.hashCode();
    }

    // equals
    public boolean equals(Object o) {
        if(o == null || !(o instanceof EQLRes)) {
            return false;
        }

        if(o == this) {
            return true;
        }

        EQLRes obj = (EQLRes) o;
        return records.equals(obj.records);
    }
}
