/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>EQL sql object. Contains sql queries (main and for datasets) with parameters</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.2 $ $Date: 2006/01/20 15:19:10 $
 */

public class EQLSql
        implements java.io.Serializable {

    // ------------------------------------------------------- variables

    // Main sql query
    private String mainSql;

    // Count sql query
    private String countSql;

    // Parameters for main sql
    private EQLObject[] sqlParams;

    // List of dataset EQLSql objects
    private List datasetEqlSqlList = new ArrayList();

    // ------------------------------------------------------- business methods

    //
    // main sql
    //

    public void setMainSql(String mainSql) {
        this.mainSql = mainSql;
    }

    public String getMainSql() {
        return mainSql;
    }

    //
    // count sql
    //

    public void setCountSql(String countSql) {
        this.countSql = countSql;
    }

    public String getCountSql() {
        return countSql;
    }

    //
    // sql parametsrs
    //

    public void setSqlParameters(EQLObject[] sqlParams) {
        this.sqlParams = sqlParams;
    }

    public EQLObject[] getSqlParameters() {
        return sqlParams;
    }

    public int getSqlParameterSize() {
        return sqlParams == null ? 0:sqlParams.length;
    }

    public EQLObject getSqlParameter(int i) {
        if(getSqlParameterSize() <= i) {
            return null;
        }

        return sqlParams[i];
    }

    //
    // dataset sqls
    //

    public List getDatasetEqlSqls() {
        return datasetEqlSqlList;
    }

    public int datasetEqlSqlSize() {
        return datasetEqlSqlList == null ? 0:datasetEqlSqlList.size();
    }

    public EQLSql getDatasetEqlSql(int i) {
        if(datasetEqlSqlSize() <= i) {
            return null;
        }

        return (EQLSql) datasetEqlSqlList.get(i);
    }

    public void addDatasetEqlSql(EQLSql datasetEqlSql) {
        datasetEqlSqlList.add(datasetEqlSql);
    }

    /**
     * Get object as string
     *
     * @return string
     */
    public String toString() {
        String s = (mainSql == null) ? "<NULL>":mainSql + "\n";

        for(int i = 0; i < getSqlParameterSize(); i++) {
            s += "    PARAM [" + i + "]: " + getSqlParameter(i).toShortString()
                    + " CLASS=" +
                    getSqlParameter(i).getClass().getName() + "\n";
        }

        for(int i = 0; i < datasetEqlSqlSize(); i++) {
            s += "[" + getDatasetEqlSql(i) + "]";
        }

        return s;
    }
}
