/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql.ejb;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.eql.CompoundKey;
import com.queplix.core.modules.eql.EQLERes;
import com.queplix.core.modules.eql.EQLReqMetaData;
import com.queplix.core.modules.eql.EQLRes;
import com.queplix.core.modules.eql.EQLResRecord;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.parser.EQLIntPreparedStatement;
import com.queplix.core.modules.eql.utils.cache.EQLResCacheObject;

/**
 * EQL Manager EJB local interface.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:23 $
 */

public interface EQLManagerLocal
        extends javax.ejb.EJBLocalObject {

    int selectCount(LogonSession ls, EQLRes res)
            throws EQLException;

    EQLERes select(LogonSession ls, Entity entity)
            throws EQLException;

    EQLERes select(LogonSession ls, Entity entity, EQLReqMetaData meta)
            throws EQLException;

    EQLERes select(LogonSession ls,
                   Entity entity,
                   Entity pkeyEntity,
                   CompoundKey[] compoundPkeys,
                   EQLReqMetaData meta)
            throws EQLException;

    EQLRes select(LogonSession ls, String eqlQuery)
            throws EQLException;

    EQLRes select(LogonSession ls, String eqlQuery,
                  EQLIntPreparedStatement eqlPS)
            throws EQLException;

    EQLRes select(LogonSession ls,
                  String eqlQuery,
                  EQLIntPreparedStatement eqlPS,
                  EQLReqMetaData meta)
            throws EQLException;

    EQLRes selectNew(LogonSession ls, Efield field)
            throws EQLException;

    EQLERes selectNew(LogonSession ls, Entity entity)
            throws EQLException;

    void update(LogonSession ls, EQLERes res)
            throws EQLException;

    void update(LogonSession ls, EQLERes res, EQLResRecord record)
            throws EQLException;

    void delete(LogonSession ls, Entity entity, CompoundKey[] compoundPkeys)
            throws EQLException;

    EQLResCacheObject getCache(LogonSession ls, Entity entity)
            throws EQLException;

    int getAffectedRowsCounter();
}
