/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql.error;

/**
 * EQL system exception subclass.
 * Is thrown when EQL UPDATE (in new mode) query conflicts with
 * a unique index constraint.
 *
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:25 $
 */
public class EQLIndexConflictException extends EQLConstraintViolationException {

    /**
     * Creates a new EQL exception.
     *
     * @param messsage error message
     * @param t        exception cause
     */
    public EQLIndexConflictException(String messsage, Throwable t) {
        super(messsage, t);
    }

}
