/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql.error;

import com.queplix.core.error.LocalizedAppException;

/**
 * <p>EQL Lock app exception. Contains info about user who locked the record</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:25 $
 */

public final class EQLLockException
        extends EQLException
        implements LocalizedAppException {

    private static final String UNKNOWN = "<unknown>";

    private String loginName;
    private String userTypeName;
    private String focusName;
    private Long focusInstance;

    // Constructor
    public EQLLockException(String loginName,
                            String userTypeName,
                            String focusName,
                            Long focusInstance) {

        super("lock_record_exception");

        this.loginName = loginName;
        this.userTypeName = userTypeName;

        this.focusName = focusName;
        this.focusInstance = focusInstance;
    }

    /*
     * No javadoc
     * @see LocalizedAppException#getArgs
     */
    public Object[] getArgs() {
        return new String[]{
                (loginName == null ? UNKNOWN:loginName),
                (userTypeName == null ? UNKNOWN:userTypeName),
                (focusName == null ? UNKNOWN:focusName),
                (focusInstance == null ? UNKNOWN:focusInstance.toString())
        };
    }
}
