/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql.error;

import com.queplix.core.error.LocalizedAppException;

/**
 * <p>User Query parse app exception</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:25 $
 */

public class UserQueryParseException
        extends EQLException implements LocalizedAppException {

    private String value;
    private String entityName;
    private String fieldCaption;
    private String comments;

    /**
     * Constructor
     *
     * @param value         bad value
     * @param entityCaption Entity object caption attribute
     * @param fieldCaption  Efield object caption attribute
     */
    public UserQueryParseException(String value, String entityCaption,
                                   String fieldCaption) {
        this(value, entityCaption, fieldCaption, null);
    }

    /**
     * Constructor
     *
     * @param value         bad value
     * @param entityCaption Entity object caption attribute
     * @param fieldCaption  Efield object caption attribute
     * @param comments      comments
     */
    public UserQueryParseException(String value, String entityCaption,
                                   String fieldCaption, String comments) {
        this(value, entityCaption, fieldCaption, comments, null);
    }

    /**
     * Constructor
     *
     * @param value        bad value
     * @param entityName   Entity object caption attribute
     * @param fieldCaption Efield object caption attribute
     * @param comments     optional comment
     * @param ex           caused by
     */
    public UserQueryParseException(String value, String entityName,
                                   String fieldCaption, String comments,
                                   Throwable ex) {
//        super("EQL parse exception with parameters: {" +
//                "value='" + value + '\'' +
//                ", entityName='" + entityName + '\'' +
//                ", fieldCaption='" + fieldCaption + '\'' +
//                ", comments='" + comments + '\'' +
//                '}', ex );
        super("user_query_parse_exception", ex);

        if(value == null) {
            this.value = "NULL";
        } else {
            this.value = "'" + value + "'";
        }

        this.entityName = entityName;
        this.fieldCaption = fieldCaption;

        if(comments == null) {
            this.comments = "";
        } else {
            this.comments = ".\n\n\n" + comments;
        }
    }

    public String toString() {
        return "UserQueryParseException{" +
                "value='" + value + '\'' +
                ", entityName='" + entityName + '\'' +
                ", fieldCaption='" + fieldCaption + '\'' +
                ", comments='" + comments + '\'' +
                '}';
    }

    public String getValue() {
        return value;
    }

    public String getEntityName() {
        return entityName;
    }

    public String getFieldCaption() {
        return fieldCaption;
    }

    public String getComments() {
        return comments;
    }

    /**
     * Get message arguments
     *
     * @return message arguments
     */
    public Object[] getArgs() {
        return new String[]{
                value,
                entityName,
                fieldCaption,
                comments
        };
    }
}
