/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql.history;

import com.queplix.core.modules.eql.EQLResRecord;
import com.queplix.core.modules.eql.jxb.history.HistoryTopic;
import com.queplix.core.modules.eql.parser.EQLPluggableModule;

import java.util.List;

/**
 * History builder abstract class.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:26 $
 */

public abstract class HistoryBuilder
        extends EQLPluggableModule {

    /**
     * Creates a new history topic.
     *
     * @param resRecord         given EQL response record
     * @param historyFieldNames list of records wich should be added in history
     * @return HistoryTopic object
     */
    public abstract HistoryTopic createHistoryTopic(EQLResRecord resRecord,
                                                    List historyFieldNames);

    /**
     * Returns a list of fields for which history should be tracked.
     *
     * @param dbObject db table name
     * @return List of field names
     */
    public abstract List getLogFieldNames(String dbObject);

}