/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql.update;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.utils.dao.AbstractPropertyFactory;

import java.io.InputStream;
import java.util.Properties;

/**
 * <p>Factory class for working with update classes</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.2 $ $Date: 2005/10/26 14:03:51 $
 */

public class EntityUpdateFactory {

    private static final String FILE_NAME = "update.properties";
    private static Class CLASS = EntityUpdateFactory.class;

    private static Properties props;

    // load optional properties
    static {
        try {
            props = AbstractPropertyFactory.loadSysProperties(
                    CLASS, FILE_NAME);
        } catch (Exception ex) {
            props = null;
            ex.printStackTrace();
        }
    }

    /**
     * Get EntityUpdate object
     *
     * @param name update name
     * @param euo  EntityUpdateObject object
     * @return new update object
     */
    public static EntityUpdate getEntityUpdate(String name,
                                               EntityUpdateObject euo) {

        try {
            String className = getProps().getProperty(name);
            EntityUpdate update = (EntityUpdate) Class.forName(className)
                    .newInstance();
            update.setEUO(euo);
            return update;

        } catch (Exception ex) {
            throw new GenericSystemException("Cannot load update object '" +
                    name + "' from properties '" +
                    FILE_NAME + "'", ex);
        }
    }

    /**
     * Constructor
     */
    private EntityUpdateFactory() {
    }

    /**
     * Get properties
     *
     * @return Properties object
     */
    private static Properties getProps() {
        if(props == null) {
            throw new GenericSystemException(
                    "Cannot load class properties '" + FILE_NAME + "'");
        } else {
            return props;
        }
    }
}
