/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eqlext.actions;

import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.modules.eql.EQLERes;
import com.queplix.core.modules.eql.EQLObject;
import com.queplix.core.modules.eql.EQLRes;
import com.queplix.core.modules.eql.ejb.EQLManagerLocal;
import com.queplix.core.modules.eql.ejb.LockManagerLocal;
import com.queplix.core.modules.eql.ejb.LockManagerLocalHome;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.cache.CacheObjectManager;

/**
 * <p>Update Set Records Action</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:37 $
 */

public final class UpdateSRAction
        extends AbstractSRAction {

    // bean instance cache
    protected CacheObjectManager com = new CacheObjectManager();

    // ------------------ PROTECETED METHODS -----------------

    /*
     * No javadoc
     * @see AbstractSRAction#callEQLManager
     */

    protected void callEQLManager(EQLERes eqlRes)
            throws EQLException {

        if(sreq.getChecklock().booleanValue()) {
            // check lock
            LockManagerLocal lockManager = (LockManagerLocal)
                    com.getLocalObject(JNDINames.LockManager,
                            LockManagerLocalHome.class);
            lockManager.check(eqlRes, ctx.getSC());
        }

        EQLManagerLocal local = ctx.getEQLManager();

        // do update
        local.update(ctx.getSC(), eqlRes);
    }

    /*
     * No javadoc
     * @see AbstractSRAction#callEQLManager
     */
    protected EQLObject callEQLManager(Efield field)
            throws EQLException {

        EQLManagerLocal local = ctx.getEQLManager();

        // do select NEW
        EQLRes res = local.selectNew(ctx.getSC(), field);
        return res.getRecord(0).getResCell(0).getEQLObject();
    }
}
