/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eqlext.actions.filters;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.modules.eqlext.jxb.gr.Req;
import com.queplix.core.modules.eqlext.jxb.gr.ReqEntity;
import com.queplix.core.modules.eqlext.jxb.gr.Reqs;
import com.queplix.core.utils.dao.AbstractPropertyFactory;

import java.io.InputStream;
import java.util.Properties;

/**
 * <p>Factory class for working with Entity GetRecords Filter classes</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.3 $ $Date: 2006/04/13 13:43:41 $
 */

public class EntityGRFilterFactory
        implements java.io.Serializable {

    private static final String FILE_NAME = "eqlext.filter.properties";
    private static Class CLASS = EntityGRFilterFactory.class;

    private static Properties props;

    // load optional properties
    static {
        try {
            InputStream is = AbstractPropertyFactory.loadSysPropertiesAsStream(
                    CLASS, FILE_NAME);
            props = new Properties();
            props.load(is);

        } catch (Exception ex) {
            ex.printStackTrace();
            props = null;
        }
    }

    /**
     * Get EntityGRFilter object by the Form name
     *
     * @param reqs Get Records request object
     * @return filter object or NULL if no any found
     */
    public static EntityGRFilter getEntityGRFilter(Reqs reqs) {
        Req req = reqs.getReq();
        if(req == null) {
            return null;
        }

        ReqEntity reqEntity = req.getReqEntity();
        if(reqEntity == null) {
            return null;
        }

        String formName = reqEntity.getFormid();
        String entityName = reqEntity
                .getName(); // NRA code for getting Entity name

        if(formName == null && entityName == null) {
            return null;
        }

        try {
            String className = null;
            if(formName != null) {
                className = props.getProperty(formName);
            }
            if(className == null && entityName != null) {
                className = props.getProperty(entityName);
            }
            if(className != null) {
                return (EntityGRFilter) Class.forName(className).newInstance();
            }

        } catch (Exception ex) {
            throw new GenericSystemException("Can't load Entity GR filter '" +
                    formName + "' from properties '" +
                    FILE_NAME + "'", ex);
        }

        return null;
    }
}
