/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eqlext.error;

import com.queplix.core.modules.eql.error.EQLSystemException;

import java.io.IOException;

/**
 * Is thrown on I/O errors.
 *
 * @author [ALB] Baranov Andrey
 */

public class FileManagerException
        extends EQLSystemException {

    /**
     * Creates the exception with the error message.
     *
     * @param message error message
     */
    public FileManagerException(String message) {
        super(message);
    }

    /**
     * Creates the exception based on the <code>SecurityException</code>.
     *
     * @param ex exception cause
     */
    public FileManagerException(SecurityException ex) {
        super(ex.getMessage(), ex);
    }

    /**
     * Creates the exception based on the <code>IOException</code>.
     *
     * @param ex exception cause
     */
    public FileManagerException(IOException ex) {
        super(ex.getMessage(), ex);
    }
}
