/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eqlext.rpc;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.utils.DateHelper;
import com.queplix.core.utils.SystemHelper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Provides RPC for EqlExt module.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:39 $
 */

public final class EqlextRPC {

    // ========================================================== Callback handlers

    /**
     * Get default time action.
     *
     * @param ls user logon session
     * @return List contains two elements: time in millis and formatted date
     */
    public static List getDefaultTime(LogonSession ls) {

        // Checking.
        if(ls == null) {
            throw new NullPointerException("LogonSession is NULL");
        }

        long defaultTime = DateHelper.toUser(DateHelper.currentTimeMillis(),
                SystemHelper.DEFAULT_TIMEZONE);

        String formattedDate = DateHelper.formatDate(new Date(defaultTime),
                SystemHelper.DEFAULT_DATE_PATTERN,
                SystemHelper.DEFAULT_TIME_PATTERN,
                SystemHelper.DEFAULT_LOCALE);

        List ret = new ArrayList();
        ret.add("" + defaultTime);
        ret.add(formattedDate);

        return ret;
    }
}
