/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eqlext.update.impl;

import com.queplix.core.integrator.security.AccessRightsManager;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.integrator.security.NoSuchUserException;
import com.queplix.core.integrator.security.User;
import com.queplix.core.modules.eql.ejb.LockManagerLocal;
import com.queplix.core.modules.eql.ejb.LockManagerLocalHome;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.modules.jeo.gen.LockObject;
import com.queplix.core.modules.jeo.gen.LockObjectHandler;
import com.queplix.core.utils.JNDINames;

/**
 * Lock update.
 *
 * @author [SKJ] Svetlin Jekov
 * @version $Revision$ $Date$
 */
public class ReleaseLockUpdate
        extends EntityUpdate {

    // ========================================================== Delete handler

    /**
     * Delete handler.
     *
     * @return delete status
     * @throws EQLException
     */
    public int delete()
            throws EQLException {

        long time = System.currentTimeMillis();
        INFO("Deleteing of the DB LOCK started...");

        // Initialization.
        JEOManagerLocal jeoManager = (JEOManagerLocal) getCOM().getLocalObject(
                JNDINames.JEOManager, JEOManagerLocalHome.class);
        /*
        no admins anymore
        LogonSession ls = getEUO().getSession().getLogonSession();

        // Check request, if non-admin.
        if( !ls.isAdmin() ) {
            // Throw an error, if it the user is not the Admin
            throw new EQLException( "You are not authorized." );
        }*/

        // Get the current lock record.
        JEObjectHandler hnd = getJEOHandler(jeoManager,
                LockObjectHandler.class);
        LockObject lockObject = (LockObject) hnd.getJEObject();

        String sessionId = lockObject.getSession_id();
        Long userId = lockObject.getUser_id();

        // get the user
        User user;
        try {
            user = AccessRightsManager.getUser(userId);
        } catch (NoSuchUserException e) {
            throw new EQLException("There is no such User with ID = " + userId);
        }

        // create a logon session for user
        LogonSession userls = AccessRightsManager.getLogonSessionForUser(user,
                sessionId);

        // unlock the users locks
        LockManagerLocal local = (LockManagerLocal) getCOM()
                .getLocalObject(JNDINames.LockManager,
                        LockManagerLocalHome.class);
        local.unlock(userls);

        if(getLogger().isInfoEnabled()) {
            INFO("Lock: Focus : " + lockObject.getFocus_id() + "\n"
                    + "User ID : " + lockObject.getUser_id() + "\n"
                    + "Table name : " + lockObject.getTable_name() + "\n"
                    + "Completed in (ms) = "
                    + (System.currentTimeMillis() - time));
        }

        // skip standard deletion procedure
        return SKIP_RECORD;
    }
}
