/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.modules.inbox.ejb;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.inbox.InboxMessage;

import javax.ejb.EJBLocalObject;
import javax.mail.MessagingException;
import java.util.Properties;

/**
 * Inbox Manager EJB local home interface.
 *
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public interface InboxManagerLocal extends EJBLocalObject {

    long getUniqueMessageID();

    boolean saveMailToInbox(LogonSession ls, InboxMessage message);

    void saveMailToOutbox(LogonSession ls, InboxMessage message);

    void saveMailToTrash(LogonSession ls, InboxMessage message);
    
    void setMessageReadFlag(long messageId, boolean isRead);

    boolean hasUnreadMessages(LogonSession ls);
        
    boolean sendEmailMessage(LogonSession ls, InboxMessage message,
                             Properties mailHeaders)
            throws MessagingException;

    boolean sendAlertMessage(LogonSession ls, InboxMessage inboxMessage);

    boolean linkAttachmentsToObject(LogonSession ls, InboxMessage inboxMessage);

    boolean setImageAttachmentLoader(LogonSession ls,
                                     InboxMessage inboxMessage);

    boolean changeReferenceHTMLATAG(LogonSession ls, InboxMessage inboxMessage);
    void deleteTempAttachment(LogonSession ls, InboxMessage inboxMessage);

} // interface InboxManagerLocal
