/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.modules.inbox.update.impl;

import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;
import com.queplix.core.modules.inbox.InboxHelper;
import com.queplix.core.modules.services.jxb.types.DelayunitSType;
import com.queplix.core.utils.DateHelper;

/**
 * <p>Update mail account entity</p>
 *
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public class AccountUpdate extends EntityUpdate {

    /*
     * No javadoc
     * @see EntityUpdate#beforeUpdate
     */
    public int beforeUpdate() throws EQLException {

        DEBUG("Mail account update");

        // checking account parameters
        // set 'created_by' attribute
        if(getNewValue("created_by") == null) {
            getCell("created_by").setString(Long.toString(
                    getLogonSession().getUser().getUserID()));
        }

        // set 'next_date'
        if(getNewValue("next_check_date") == null) {
            getCell("next_check_date").setDate(DateHelper.getNowDate());
        }

        // set 'delay'
        if(getNewValue("delay") == null) {
            getCell("delay").setString(String.valueOf(
                    DelayunitSType.MIN_TYPE)); // Minutes
        }

        String provider = (String) getNewValue("account_provider");
        if(provider == null) {
            throwUserQueryParseException("account_provider", null);
        }

        Integer deleteFlag = (Integer) getNewValue("delete_email_flag");
        Integer seenFlag = (Integer) getNewValue("unread_email_flag");
        if(deleteFlag != null && deleteFlag.intValue() > 0 && seenFlag != null
                && seenFlag.intValue() > 0) {
            throwUserQueryParseException("unread_email_flag", "" + seenFlag);
        }

        // special checks
        // check POP3 account
        if(provider != null) {
            if(provider.equals(InboxHelper.ACCOUNT_POP3)) {
                // 1. Check 'Folder'
                String folder = (String) getNewValue("folder");
                if(folder != null && !folder.equalsIgnoreCase("INBOX")) {
                    throwUserQueryParseException("folder", folder,
                            "Only 'INBOX' folder supported by POP3 provider");
                } // if (folder != null && !folder.equalsIgnoreCase("INBOX"))

                // 2. Check 'Seen flag'.
                if(seenFlag != null && seenFlag.intValue() > 0) {
                    throwUserQueryParseException("folder", "" + seenFlag,
                            "Not supported by POP3 provider");
                } // if (seenFlag != null && seenFlag.intValue() > 0)
            } // if (provider.equals(InboxHelper.ACCOUNT_POP3))
        } // if (provider != null)
        return CONTINUE;
    } // beforeUpdate() : int
}
