/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.inbox.utils;

import com.queplix.core.modules.inbox.Account;
import com.queplix.core.modules.inbox.utils.log.SystemLogPublisher;

/**
 * <p>Inbox pluggable module interface</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1 $ $Date: 2006/01/20 15:19:10 $
 */

public interface InboxPluggableModule {

    /**
     * Set Account.
     *
     * @param account Account
     */
    void setAccount(Account account);

    /**
     * Get Account.
     *
     * @return Account
     */
    Account getAccount();

    /**
     * Set Log Publisher.
     *
     * @param publisher SystemLogPublisher
     */
    void setLogPublisher(SystemLogPublisher publisher);

    /**
     * Get Log Publisher.
     *
     * @return SystemLogPublisher
     */
    SystemLogPublisher getLogPublisher();

    /**
     * Set Log Name.
     *
     * @param logName String
     */
    void setLogName(String logName);

    /**
     * Get Log Name.
     *
     * @return String
     */
    String getLogName();
}
