/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.modules.inbox.utils.filters;

import com.queplix.core.modules.inbox.InboxMessage;
import com.queplix.core.modules.inbox.ejb.InboxManagerLocal;
import com.queplix.core.modules.inbox.utils.AbstractMailFilter;
import com.queplix.core.modules.inbox.utils.log.AbstractInboxLogPublisher;
import com.queplix.core.modules.inbox.utils.log.InboxLogPublisher;

/**
 * The filter saves the message into the Inbox.
 *
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public class ApplyFilter extends AbstractMailFilter {

    // ------------------------------------------------------- Main method

    /*
     * No javadoc
     * @see MailFilter#filterMail
     */

    public boolean filterMail(InboxMessage inboxMessage) {

        inboxPublisher.DEBUG("Email Apply filter is started...");

        // check and set description field
        // Saving to INBOX.
        InboxManagerLocal local = getInboxManager();
        local.saveMailToInbox(getLogonSession(), inboxMessage);
        // Ok.
        inboxPublisher.DEBUG("Email Apply filter was finished...");
        return true;

    } // filterMail(InboxMessage) : boolean

    // ------------------------------------------------------- Protected methods

    /*
     * No javadoc
     * @see AbstractMailFilter#createInboxLogPublisher
     */

    protected AbstractInboxLogPublisher createInboxLogPublisher() {
        return new InboxLogPublisher(getLogonSession());
    }

} // class ApplyFilter extends AbstractMailFilter
