/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.modules.inbox.utils.log;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.inbox.InboxMessage;
import com.queplix.core.modules.services.utils.log.Level;
import com.queplix.core.modules.services.utils.log.impl.BaseLogPublisher;

/**
 * This is abstract inbox publisher.
 *
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public abstract class AbstractInboxLogPublisher extends BaseLogPublisher {

    // ========================================================== Initialization

    /**
     * Constructor.
     *
     * @param ls logon session
     */
    AbstractInboxLogPublisher(LogonSession ls) {
        super(ls);
    }

    // ========================================================== Public methods

    /**
     * Logs an error message.
     *
     * @param message message to log
     * @param im      InboxMessage
     */
    public final void ERROR(String message, InboxMessage im) {
        publish(message, im, Level.ERROR);
    }

    /**
     * Logs a warning.
     *
     * @param message message to log
     * @param im      InboxMessage
     */
    public final void WARN(String message, InboxMessage im) {
        publish(message, im, Level.WARNING);
    }

    /**
     * Logs an informational message.
     *
     * @param message message to log
     * @param im      InboxMessage
     */
    public final void INFO(String message, InboxMessage im) {
        publish(message, im, Level.INFO);
    }

    /**
     * Logs a debug message.
     *
     * @param message message to log
     * @param im      InboxMessage
     */
    public final void DEBUG(String message, InboxMessage im) {
        publish(message, im, Level.DEBUG);
    }

    // ========================================================== Friend methods

    // Logs the message.

    abstract void publish(String message, InboxMessage im, Level level);

} // abstract class AbstractInboxLogPublisher
