/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.modules.inbox.utils.log;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.inbox.InboxMessage;
import com.queplix.core.modules.services.utils.log.Level;

/**
 * This is Inbox log publisher.
 *
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public final class InboxLogPublisher extends AbstractInboxLogPublisher {

    // ========================================================== Initialization

    /**
     * Creates a new log publisher.
     *
     * @param ls logon session
     */
    public InboxLogPublisher(LogonSession ls) {
        super(ls);
    }

    // ========================================================== Friend methods

    // Logs the message.

    void publish(String message, InboxMessage im, Level level) {

        LogonSession ls = getLogonSession();
        long processID = getProcessID();
        InboxLogRecord lr = new InboxLogRecord(ls, level, message, processID,
                im);
        publish(lr);
    } // publish(String, InboxMessage, Level)
} // final class InboxLogPublisher
