/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.jeo;

/**
 * <p>Java Entity Object interface.
 * This interface is a wrapper around com.queplix.core.modules.eql.EQLResRecord object.
 * </p>
 * <p>Here you can add following methods:<br>
 * <br><li><code>void set&lt;FieldName&gt;( Object value )</code> - field value setter
 * <br><li><code>java.lang.Object get&lt;FieldName&gt;()</code> - field value getter
 * <br><li><code>java.lang.Object old&lt;FieldName&gt;()</code> - old field value getter
 * <br><li><code>java.lang.Object text&lt;FieldName&gt;()</code> - list field value getter
 * <br><li><code>boolean isChanged&lt;FieldName&gt;()</code> - is field value changed
 * <br><li><code>boolean isNull&lt;FieldName&gt;()</code> - is field  value NULL
 * <br><li><code>java.util.List ds&lt;DatasetName&gt;( java.lang.Class )</code> - dataset handlers getter
 * </p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:46 $
 * @todo Make autogeneration of these interfaces
 */

public interface JEObject
        extends java.io.Serializable {

    /**
     * Return master handler
     *
     * @return JEObjectHandler JEObjectHandler object
     */
    JEObjectHandler getJEObjectHandler();
}
