/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

import java.util.List;

/**
 * <p>Alert block object handler</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:47 $
 */
public class AlertBlockObjectHandler
        extends JEObjectHandler {

    public static final String ENTITY = "alert_block";

    public String getEntityName() {
        return ENTITY;
    }

    public Class getObjectClass() {
        return AlertBlockObject.class;
    }

    public static List selectByAlertId(JEOManagerLocal local, LogonSession ls,
                                       long alertID)
            throws EQLException {
        return local.select(ls, AlertBlockObjectHandler.class,
                "SELECT alert_block.* WHERE alert_block.alert_id = " + alertID);

    }
}
