/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.modules.jeo.gen;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObject;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

import java.util.List;

/**
 * Autoreply Handler.
 *
 * @author Kostantin Mironov
 * @since 8 Dec 2006
 */
public class AutoreplyObjectHandler extends JEObjectHandler {

    public static final String ENTITY = "auto_reply";

    public String getEntityName() {
        return ENTITY;
    }

    public Class getObjectClass() {
        return AutoreplyObject.class;
    }

    /**
     * The method returns a record by pkey.
     *
     * @param jeoManager JEOManager EJB local interface
     * @param ls         LogonSession object with security data
     * @param pkey       record pkey
     * @return List of inbox JEO handlers
     * @throws EQLException
     */
    public static AutoreplyObject selectByPkey(JEOManagerLocal jeoManager,
                                               LogonSession ls, long pkey)
            throws EQLException {

        String eql = "select auto_reply.* where auto_reply.pkey = " + pkey;
        List hndList = jeoManager.select(ls, AutoreplyObjectHandler.class, eql);
        if(hndList == null) {
            return null;
        }
        JEObject jeo = ((JEObjectHandler) hndList.get(0)).getJEObject();
        return (AutoreplyObject) jeo;
    } // selectByPkey(JEOManagerLocal, LogonSession, long) : AutoreplyObject

} // class AutoreplyObjectHandler
