/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.modules.jeo.JEObject;

import java.util.Date;

/**
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public interface InboxObject
        extends JEObject {

    Long getPkey();

    Integer getMessage_type();

    Long getMessage_sender();

    String getMessage_sender_email();

    Long getRecipient_id();

    Long getWorkgroup_id();

    String getEmail_to();

    String getEmail_cc();

    String getSubject();

    char[] getMessage();

    Date getSent_date();

    Date getServer_received_date();

    Date getReceived_date();

    Integer getObject_type();

    Long getObject_id();

    Date getReplied_date();

    Long getProcess_id();

    Long getAccount_id();

    String getDigest_src();

    Integer getDelete_flag();

    void setPkey(Long l);

    void setMessage_type(Integer i);

    void setMessage_sender(Long l);

    void setMessage_sender_email(String s);

    void setRecipient_id(Long l);

    void setWorkgroup_id(Long l);

    void setEmail_to(String s);

    void setEmail_cc(String s);

    void setSubject(String s);

    void setMessage(char[] ch);

    void setSent_date(Date d);

    void setServer_received_date(Date d);

    void setReceived_date(Date d);

    void setObject_type(Integer i);

    void setObject_id(Long l);

    void setReplied_date(Date d);

    void setProcess_id(Long l);

    void setAccount_id(Long l);

    void setDigest_src(String s);

    void setDelete_flag(Integer i);

} // interface InboxObject
