/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TicketProductObjectHandler extends JEObjectHandler {

    private final static String ENTITY_NAME = "product.ticket";

    public String getEntityName() {
        return ENTITY_NAME;
    }

    public Class getObjectClass() {
        return TicketProductObject.class;
    }

    public List<TicketProductObject> selectAll(JEOManagerLocal manager,
                                               LogonSession ls)
            throws EQLException {
        String eql = "select " + ENTITY_NAME + ".*";
        List hndList = manager.select(ls, getClass(), eql);
        if(hndList == null) {
            return null;
        }

        List<TicketProductObject> statusList
                = new ArrayList<TicketProductObject>();
        for(Iterator iter = hndList.iterator(); iter.hasNext();) {
            JEObjectHandler hnd = (JEObjectHandler) iter.next();
            statusList.add((TicketProductObject) hnd.getJEObject());
        }
        return statusList;

    }

}
