/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

import java.util.List;

/**
 * Upload folder object JEO handler.
 *
 * @author [DBR] Daniil B. Raskin
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:48 $
 */
public class UploadFolderObjectHandler
        extends JEObjectHandler {

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler#getEntityName()
     */

    public String getEntityName() {
        return "uploadfolder";
    }

    /* (non-Javadoc)
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return UploadFolderObject.class;
    }

    // ============================================================= EQL methods

    /**
     * Gets the upload folder object by ID.
     *
     * @param jeoManager JEOManager EJB local interface
     * @param ls         LogonSession object with security data
     * @param folderID   folder object ID to search by
     * @return folder object JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static JEObjectHandler selectByFolderID(
            JEOManagerLocal jeoManager,
            LogonSession ls,
            long folderID)
            throws EQLException {

        String eql = "select uploadfolder.* where uploadfolder.folder_id = "
                + folderID;
        List hndList = jeoManager.select(ls, UploadFolderObjectHandler.class,
                eql);
        return (hndList != null) ? (JEObjectHandler) hndList.get(0):null;
    }

    /**
     * Gets the upload folder object by ID.
     *
     * @param jeoManager JEOManager EJB local interface
     * @param ls         LogonSession object with security data
     * @return folder object JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static List getAllFolders(JEOManagerLocal jeoManager,
                                     LogonSession ls)
            throws EQLException {

        String eql = "select uploadfolder.*";
        return jeoManager.select(ls, UploadFolderObjectHandler.class, eql);
    }

}
