/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.mail.ejb;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.jeo.gen.AttachmentTempObject;
import com.queplix.core.modules.mail.Attachment;
import com.queplix.core.modules.mail.MailMessage;

import javax.ejb.EJBLocalObject;
import javax.mail.MessagingException;
import java.util.Properties;

/**
 * Mail Manager EJB local home interface.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.3 $ $Date: 2006/01/26 15:00:53 $
 */

public interface MailManagerLocal
        extends EJBLocalObject {

    void sendMessage(LogonSession ls, MailMessage message)
            throws MessagingException;

    void sendMessage(LogonSession ls, MailMessage message,
                     Properties mailHeaders)
            throws MessagingException;

    void sendMessage(LogonSession ls,
                     MailMessage message,
                     Properties mailHeaders,
                     Attachment[] attachments)
            throws MessagingException;

    void sendMessage(LogonSession ls,
                     MailMessage message,
                     Properties mailHeaders,
                     Attachment[] attachments,
                     AttachmentTempObject[] dbAttachments)
            throws MessagingException;
}
