/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.services;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.services.utils.log.AbstractLogPublisher;

/**
 * XA action context.
 * Extends the {@link com.queplix.core.modules.services.ActionContext ActionContext}
 * for XA-enabled actions.
 *
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:59 $
 */
public final class XAActionContext
        extends ActionContext {

    // ================================================================== Fields

    // Logger.
    private AbstractLogPublisher log;

    // ========================================================== Initialization

    /* (non-Javadoc)
     * @see ActionContext#ActionContext(LogonSession)
     */

    public XAActionContext(LogonSession ls) {
        super(ls);
    }

    /**
     * Creates a new XA action context with the bound logger.
     *
     * @param ls  logon session
     * @param log logger
     */
    public XAActionContext(LogonSession ls, AbstractLogPublisher log) {
        super(ls);
        this.log = log;
    }

    // ========================================================== Access methods

    /**
     * Logger getter.
     *
     * @return bound logger
     */
    public AbstractLogPublisher getLog() {
        return log;
    }

}
